/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vseclogs;

import com.ibm.hwmca.base.filed.FileDialogTasklet;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.vseclogs.E4Logs;
import com.ibm.hwmca.base.vseclogs.E4LogsInterface;
import com.ibm.hwmca.base.vseclogs.ViewSecurityLogsBean;
import com.ibm.hwmca.base.vseclogs.ViewSecurityLogsDateBean;
import com.ibm.hwmca.base.vseclogs.ViewSecurityLogsErrorIds;
import com.ibm.hwmca.base.vseclogs.ViewSecurityLogsEventBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

public class ViewSecurityLogsTasklet
extends HwmcaPanelTasklet {
    private static final String TRACE_MASKT = "VE4LTLTT";
    private static final String TRACE_MASKF = "VE4LTLTF";
    private static final String TRACE_MASKD = "VE4LTLTD";
    private static final String VE4L_AUIML = "com.ibm.hwmca.base.vseclogs.res.ViewSecurityLogsRes";
    private static final String VIEW_PANEL = "ViewSecurityLogsPanel";
    private static final String DATE_PANEL = "DateSearchPanel";
    private static final String EVENT_PANEL = "EventListPanel";
    private static final String VIEW_BEAN = "ViewSecurityLogsBean";
    private static final String DATE_BEAN = "ViewSecurityLogsDateBean";
    private static final String EVENT_BEAN = "ViewSecurityLogsEventBean";
    private static final String SERVER_SOURCE = "server";
    private static final String UPDATE_TABLE_DATA = "updateTableData";
    private static final String RESTORE_VIEW = "restoreView";
    public static final String E4_DETAILS_TITLE = "e4.details.title";
    public static final String E4_GETCONFIGERR_TITLE = "e4.getconfigerr.title";
    public static final String E4_GETCONFIGERR_TEXT = "e4.getconfigerr.text";
    public static final String E4_GETLOGSERR_TITLE = "e4.getlogserr.title";
    public static final String E4_GETLOGSERR_TEXT = "e4.getlogserr.text";
    public static final String E4_NOLOGS_TITLE = "e4.nologs.title";
    public static final String E4_NOLOGS_TEXT = "e4.nologs.text";
    private static final BaseMessageTitle getConfigErrorTitle = new BaseMessageTitle("e4.getconfigerr.title");
    private static final MessageText getConfigErrorText = new BaseMessageText("e4.getconfigerr.text");
    private static final BaseMessageTitle getLogErrorTitle = new BaseMessageTitle("e4.getlogserr.title");
    private static final MessageText getLogErrorText = new BaseMessageText("e4.getlogserr.text");
    private static final BaseMessageTitle _lNoLogsTitle = new BaseMessageTitle("e4.nologs.title");
    private static final MessageText _mNoLogsText = new BaseMessageText("e4.nologs.text");
    private E4LogsInterface e4Data = null;
    private E4Logs e4Logs = null;
    private Log[] returnedLogs = new Log[20];

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(ViewSecurityLogsErrorIds.logInfo, -24556, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String source = (String)request.getData("source");
        String cmd = (String)request.getData("command");
        Trace.trace(TRACE_MASKD, "-->service(" + source + "." + cmd + ")");
        if (request.isInitialRequest()) {
            if (this.e4Data == null) {
                this.e4Data = new E4LogsInterface();
            }
            if (this.e4Logs == null) {
                this.e4Logs = new E4Logs(this.e4Data);
                if (this.e4Data.cfgException != null) {
                    this.showMessageBox(true, getConfigErrorTitle, getConfigErrorText, MsgType.WARNING_MESSAGE, null);
                }
            }
            this.openLogs("", response);
        } else if (request.isDisposed() || request.isCanceled()) {
            response.dispose();
        } else {
            E4LogsInterface reqData = (E4LogsInterface)request.getData("e4data");
            if (reqData != null) {
                this.e4Data = reqData;
            }
            if (source == null) {
                this.serviceView(request, response);
            } else if (source.startsWith(DATE_PANEL)) {
                this.serviceDate(request, response);
            } else if (source.startsWith(EVENT_PANEL)) {
                this.serviceEvent(request, response);
            } else if (source.equals("com.ibm.hwmca.base.filed.FileDialogTasklet")) {
                this.handleOpenResponse(request, response);
            } else {
                this.serviceView(request, response);
            }
        }
        Trace.trace(TRACE_MASKD, "<--service()");
    }

    private void serviceView(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String cmd = (String)request.getData("command");
        Trace.trace(TRACE_MASKD, "--> serviceView()");
        if (cmd.endsWith("SubItem")) {
            this.handleOpenRequest(cmd, response);
        } else if (cmd.endsWith("ByDateMENUITEM")) {
            response.openModalChild(VE4L_AUIML, DATE_PANEL, this.getViewSecurityLogsDateBean());
        } else if (cmd.endsWith("ByEventMENUITEM")) {
            this.e4Logs.getMsgIdData(this.e4Data);
            response.openModalChild(VE4L_AUIML, EVENT_PANEL, this.getViewSecurityLogsEventBean());
        } else if (cmd.endsWith("DetailsItem")) {
            this.e4Data.logList = this.returnedLogs;
            this.e4Logs.displayLog(this, response, this.e4Data);
            this.e4Data.logList = null;
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SERVER_SOURCE);
            newReq.setData("command", RESTORE_VIEW);
            this.postRequest(VIEW_BEAN, newReq);
        } else if (cmd.endsWith("ShowEarlierEventsButton")) {
            this.e4Data.command = 4;
            try {
                this.getLogs();
            }
            catch (HException e) {
                new FrameworkLog(ViewSecurityLogsErrorIds.logInfo, -24555, new HException(e)).log();
                this.showMessageBox(true, getLogErrorTitle, getLogErrorText, MsgType.ERROR_MESSAGE, null);
                response.noAction();
                Trace.trace(TRACE_MASKD, "<--serviceView(): getlogs error");
                return;
            }
            response.update(this.e4Data);
        } else if (cmd.endsWith("ShowLaterEventsButton")) {
            this.e4Data.command = 2;
            try {
                this.getLogs();
            }
            catch (HException e) {
                new FrameworkLog(ViewSecurityLogsErrorIds.logInfo, -24555, new HException(e)).log();
                this.showMessageBox(true, getLogErrorTitle, getLogErrorText, MsgType.ERROR_MESSAGE, null);
                response.noAction();
                Trace.trace(TRACE_MASKD, "<--serviceView(): getlogs error");
                return;
            }
            response.update(this.e4Data);
        } else if (cmd.equals(RESTORE_VIEW)) {
            response.update(null);
        } else if (cmd.equals(UPDATE_TABLE_DATA)) {
            response.update(this.e4Data);
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKD, "<-- serviceView()");
    }

    private void handleOpenRequest(String cmd, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKD, "--> handleOpenRequest()");
        if (cmd.endsWith("DefaultSubItem")) {
            this.openLogs("", response);
        } else if (cmd.endsWith("NewLogSubItem")) {
            FileDialogTasklet.launchOpenSubtasklet(response, VIEW_BEAN, false, true);
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKD, "<-- handleOpenRequest()");
    }

    private void handleOpenResponse(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String cmd = (String)request.getData("command");
        Trace.trace(TRACE_MASKD, "--> handleOpenResponse()");
        if (cmd.equals("cancelled")) {
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SERVER_SOURCE);
            newReq.setData("command", RESTORE_VIEW);
            this.postRequest(VIEW_BEAN, newReq);
            response.noAction();
        } else if (cmd.equals("gotData")) {
            ArrayList fileList = (ArrayList)request.getData("data");
            if (fileList.size() != 1) {
                response.noAction();
            } else {
                Trace.trace(TRACE_MASKD, "use log file:" + (String)fileList.get(0));
                this.openLogs((String)fileList.get(0), response);
            }
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKD, "<-- handleOpenResponse()");
    }

    private void serviceDate(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String cmd = (String)request.getData("command");
        Trace.trace(TRACE_MASKD, "--> serviceDate()");
        if (cmd.endsWith("FindEventButton")) {
            this.e4Data.command = 8;
            try {
                this.getLogs();
            }
            catch (HException e) {
                new FrameworkLog(ViewSecurityLogsErrorIds.logInfo, -24555, new HException(e)).log();
                this.showMessageBox(true, getLogErrorTitle, getLogErrorText, MsgType.ERROR_MESSAGE, null);
                PanelTaskletRequest newReq = new PanelTaskletRequest();
                newReq.setData("source", SERVER_SOURCE);
                newReq.setData("command", RESTORE_VIEW);
                this.postRequest(VIEW_BEAN, newReq);
                response.dispose();
                Trace.trace(TRACE_MASKD, "<-- serviceDate(): getlogs error");
                return;
            }
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SERVER_SOURCE);
            newReq.setData("command", UPDATE_TABLE_DATA);
            this.postRequest(VIEW_BEAN, newReq);
            response.dispose();
        } else if (cmd.equals("CANCEL") || cmd.endsWith("CancelButton")) {
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SERVER_SOURCE);
            newReq.setData("command", RESTORE_VIEW);
            this.postRequest(VIEW_BEAN, newReq);
            response.dispose();
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKD, "<-- serviceDate()");
    }

    private void serviceEvent(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String cmd = (String)request.getData("command");
        Trace.trace(TRACE_MASKD, "--> serviceEvent(" + cmd + ")");
        if (cmd.endsWith("FindEarlierEventButton") || cmd.endsWith("FindLaterEventButton")) {
            this.e4Data.command = cmd.endsWith("FindEarlierEventButton") ? 32 : 16;
            try {
                this.getLogs();
            }
            catch (HException e) {
                new FrameworkLog(ViewSecurityLogsErrorIds.logInfo, -24555, new HException(e)).log();
                this.showMessageBox(true, getLogErrorTitle, getLogErrorText, MsgType.ERROR_MESSAGE, null);
                PanelTaskletRequest newReq = new PanelTaskletRequest();
                newReq.setData("source", SERVER_SOURCE);
                newReq.setData("command", RESTORE_VIEW);
                this.postRequest(VIEW_BEAN, newReq);
                response.dispose();
                Trace.trace(TRACE_MASKT, "<-- serviceEvent(): getlogs error");
                return;
            }
            if (this.e4Data.numLogs == 0) {
                this.showMessageBox(true, _lNoLogsTitle, _mNoLogsText, MsgType.INFORMATION_MESSAGE, null);
                PanelTaskletRequest newReq = new PanelTaskletRequest();
                newReq.setData("source", SERVER_SOURCE);
                newReq.setData("command", RESTORE_VIEW);
                this.postRequest(VIEW_BEAN, newReq);
                response.dispose();
                Trace.trace(TRACE_MASKD, "<--serviceEvent(): no logs");
                return;
            }
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SERVER_SOURCE);
            newReq.setData("command", UPDATE_TABLE_DATA);
            this.postRequest(VIEW_BEAN, newReq);
            response.dispose();
        } else if (cmd.equals("CANCEL") || cmd.endsWith("CancelButton")) {
            PanelTaskletRequest newReq = new PanelTaskletRequest();
            newReq.setData("source", SERVER_SOURCE);
            newReq.setData("command", RESTORE_VIEW);
            this.postRequest(VIEW_BEAN, newReq);
            response.dispose();
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKD, "<-- serviceEvent()");
    }

    private ViewSecurityLogsBean getViewSecurityLogsBean() throws TaskletException {
        Trace.trace(TRACE_MASKD, "<> getViewSecurityLogsBean");
        ViewSecurityLogsBean vslb = new ViewSecurityLogsBean();
        vslb.setE4data(this.e4Data);
        vslb.setPanelName(VIEW_PANEL);
        vslb.setBeanName(VIEW_BEAN);
        return vslb;
    }

    private ViewSecurityLogsDateBean getViewSecurityLogsDateBean() throws TaskletException {
        Trace.trace(TRACE_MASKD, "<> getViewSecurityLogsDateBean");
        ViewSecurityLogsDateBean vsldb = new ViewSecurityLogsDateBean();
        vsldb.setE4data(this.e4Data);
        vsldb.setPanelName(DATE_PANEL);
        vsldb.setBeanName(DATE_BEAN);
        return vsldb;
    }

    private ViewSecurityLogsEventBean getViewSecurityLogsEventBean() throws TaskletException {
        Trace.trace(TRACE_MASKD, "<> getViewSecurityLogsEventBean");
        ViewSecurityLogsEventBean vsleb = new ViewSecurityLogsEventBean();
        vsleb.setE4data(this.e4Data);
        vsleb.setPanelName(EVENT_PANEL);
        vsleb.setBeanName(EVENT_BEAN);
        return vsleb;
    }

    private void openLogs(String fileName, PanelTaskletResponse response) throws TaskletException {
        this.e4Data.fileName = fileName;
        this.e4Data.command = 1;
        try {
            this.getLogs();
        }
        catch (HException e) {
            new FrameworkLog(ViewSecurityLogsErrorIds.logInfo, -24555, new HException(e)).log();
            this.showMessageBox(true, getLogErrorTitle, getLogErrorText, MsgType.ERROR_MESSAGE, null);
            response.dispose();
            Trace.trace(TRACE_MASKD, "<--service(): getlogs error");
            return;
        }
        if (this.e4Data.numLogs == 0) {
            this.showMessageBox(true, _lNoLogsTitle, _mNoLogsText, MsgType.INFORMATION_MESSAGE, null);
            response.dispose();
            Trace.trace(TRACE_MASKD, "<--service(): no logs");
            return;
        }
        Trace.trace(TRACE_MASKD, "e4Data has " + this.e4Data.numLogs + " logs");
        response.replace(VE4L_AUIML, VIEW_PANEL, this.getViewSecurityLogsBean());
    }

    private void getLogs() throws HException {
        this.e4Data.logList = this.returnedLogs;
        this.e4Logs.getLogs(this.e4Data);
        this.returnedLogs = this.e4Data.logList;
        this.e4Data.logList = null;
    }
}

